<?php
/* *
 * 彩虹易支付SDK服务类
 * 说明：
 * 包含发起支付、查询订单、回调验证等功能
 */

class EpayCore
{
	private $pid;
	private $key;
	private $submit_url;
	private $mapi_url;
	private $api_url;
	private $sign_type = 'MD5';

	function __construct($config){
		$this->pid = $config['pid'];
		$this->key = $config['key'];
		$this->submit_url = $config['apiurl'].'submit.php';
		$this->mapi_url = $config['apiurl'].'mapi.php';
		$this->api_url = $config['apiurl'].'api.php';
	}

	// 异步回调验证
	public function verifyNotify(){
		if(empty($_GET)) return false;

		$sign = $this->getSign($_GET);

		if($sign === $_GET['sign']){
			$signResult = true;
		}else{
			$signResult = false;
		}

		return $signResult;
	}

	// 同步回调验证
	public function verifyReturn(){
		if(empty($_GET)) return false;

		$sign = $this->getSign($_GET);

		if($sign === $_GET['sign']){
			$signResult = true;
		}else{
			$signResult = false;
		}

		return $signResult;
	}


	// 计算签名
	private function getSign($param){
		ksort($param);
		reset($param);
		$signstr = '';
	
		foreach($param as $k => $v){
			if($k != "sign" && $k != "sign_type" && $v!=''){
				$signstr .= $k.'='.$v.'&';
			}
		}
		$signstr = substr($signstr,0,-1);
		$signstr .= $this->key;
		$sign = md5($signstr);
		return $sign;
	}

}
